package ru.yandex.webmaster3.storage.user.service;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;
import ru.yandex.webmaster3.storage.user.dao.DashboardSurveyAnswersYDao;

import java.util.List;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class DashboardSurveyAnswersService implements UserTakeoutDataProvider {
    private final DashboardSurveyAnswersYDao dashboardSurveyAnswersYDao;

    @Override
    public void deleteUserData(WebmasterUser user) {
        dashboardSurveyAnswersYDao.deleteForUser(user.getUserId());
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        return List.of(
            dashboardSurveyAnswersYDao.getTablePath()
        );
    }
}
