package ru.yandex.webmaster3.storage.user.service;

import lombok.RequiredArgsConstructor;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import ru.yandex.webmaster3.core.data.WebmasterUser;
import ru.yandex.webmaster3.storage.user.UserTakeoutDataProvider;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsYDao;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserSettingsYDao;

import java.util.List;

/**
 * @author leonidrom
 */
@Service
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class FrontendSettingsService implements UserTakeoutDataProvider {
    private final FrontendUserSettingsYDao frontendUserSettingsYDao;
    private final FrontendUserHostSettingsYDao frontendUserHostSettingsYDao;

    @Override
    public void deleteUserData(WebmasterUser user) {
        long userId = user.getUserId();
        frontendUserSettingsYDao.deleteForUser(userId);
        frontendUserHostSettingsYDao.deleteForUser(userId);
    }

    @Override
    public @NotNull List<String> getTakeoutTables() {
        return List.of(
                frontendUserSettingsYDao.getTablePath(),
                frontendUserHostSettingsYDao.getTablePath()
        );
    }
}
