package ru.yandex.webmaster3.storage.user.settings;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author avhaliullin
 */
public enum FrontendUserHostSettingsKey {
    @Description("Выбранные пользователем индикаторы запросов для отображения в таблице (WMC-1824)")
    SELECTED_QUERY_INDICATORS,
    @Description("Настройки отображения тизеров на дашборде сайта")
    DASHBOARD_TEASERS,
    @Description("Настройки домена для страницы ачивок (см. WMC-6441)")
    DOMAIN_QUALITY_SELECT,
    @Description("Выбранная тематика для отображения конкурентов по трендам")
    SELECTED_RADAR_THEMATICS,
    @Description("WMC-7516: popup по автопарсеру")
    TURBO_AUTOPARSER_POPUP,
    @Description("WMC-7605: Попапы для интернет-магазинов")
    TURBO_YML_TEASER,
    @Description("WMC-7605: Попапы для интернет-магазинов")
    TURBO_SHOP_TEASER,
    @Description("WMC-8515: Ключ для настроек таблицы сравнения конкурентов")
    QUALITY_RIVAL_SETTINGS,
    @Description("WMC-9799: [Бэк] СКК для Турбоеком")
    SHOP_SCC_OFF,
    @Description("WMC-9799: [Бэк] СКК для Турбоеком")
    SHOP_SCC_UNKNOWN,
    @Description("WMC-10492: [Бэк] Отключить магазины с плохой внешней корзиной")
    INVALID_OUTER_CART,

    @Description("WMC-11948: [Бэк] Добавить ключ про выбранные метричные счетчики в FrontendUserHostSettings")
    SELECTED_METRIKA_COUNTER,
    NICHE_RIVALS_CHART_VISIBILITY,
    ;

    public static final EnumResolver<FrontendUserHostSettingsKey> R = EnumResolver.er(FrontendUserHostSettingsKey.class);
}
