package ru.yandex.webmaster3.storage.user.settings;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.util.enums.EnumResolver;

/**
 * @author Oleg Bazdyrev
 * @see WMC-4465
 */
public enum FrontendUserSettingsKey {
    TURBO_VISITED,
    TURBO_PROMO_CLOSED,
    TURBO_PROMO_LIGHT_CLOSED,
    LAST_WEBMASTER_BLOG_POST_SEEN,
    CONTEXT_HELP_SEEN,
    SITEINFO_ATTENTION_CLOSED,
    RECOMMENDED_QUERIES_TAB,
    ONBOARDING_QUALITY_PASSED,
    VISITED_PAGES,
    ONBOARDING_RIVALS_PASSED,
    RIVALS_WITH_ONBOARDING_OPENED,
    TURBO_DESKTOP_VISITED,
    TURBO_LISTING_VISITED,
    EMAIL_CONFIRMATION_POPUP_LAST_SEEN_DATE,
    EMAIL_LINK_LAST_FOLLOW_DATE,
    OLD_TURBO_SOURCES,
    SURVEY_HIDE,
    @Description("WMC-7605: Попапы для интернет-магазинов")
    TURBO_YML_TEASER,
    @Description("WMC-7605: Попапы для интернет-магазинов")
    TURBO_SHOP_TEASER,
    @Description("WMC-10136: Разметка пользователей по типам.")
    DASHBOARD_SURVEY,
    SURVEY_CLOSED,
    SURVEY_HIDDEN,
    @Description("WMC-11298: [Бэк] Пользовательская настройка для уведомлений")
    NOTICE_SEEN_COUNT,
    ;

    public static final EnumResolver<FrontendUserSettingsKey> R = EnumResolver.er(FrontendUserSettingsKey.class);
}
