package ru.yandex.webmaster3.storage.util;

import java.util.*;

/**
 * @author aherman
 */
public class Cf {
    @SafeVarargs
    public static <T> ArrayList<T> arrayList(T... ts) {
        if (ts == null) {
            return new ArrayList<>();
        }
        ArrayList<T> res = new ArrayList<>(ts.length);
        Collections.addAll(res, ts);
        return res;
    }

    @SafeVarargs
    public static <T> List<T> immutableList(T... ts) {
        return Collections.unmodifiableList(arrayList(ts));
    }

    public static <T> List<T> immutableList(Collection<T> collection) {
        ArrayList<T> res = new ArrayList<>(collection.size());
        res.addAll(collection);
        return Collections.unmodifiableList(res);
    }
}
