package ru.yandex.webmaster3.storage.util;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ru.yandex.webmaster3.core.util.enums.IntEnum;

/**
 * @author aherman
 */
public class IntEnumJsonSerializer<T extends Enum<T> & IntEnum> extends JsonSerializer<T> {
    @Override
    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider)
            throws IOException, JsonProcessingException
    {
        jgen.writeNumber(value.value());
    }
}
