package ru.yandex.webmaster3.storage.util.clickhouse2;

import java.io.InputStream;

/**
 * @author aherman
 */
public abstract class BAInputStream extends InputStream {
    public abstract int read();
    public abstract void resetPosition();

    public static abstract class RandomAccessBAInputStream extends BAInputStream {
        public abstract int size();
        public abstract byte byteAt(int position);
    }

    public static class EmptyBAInputStream extends RandomAccessBAInputStream {
        @Override
        public int read() {
            return -1;
        }

        @Override
        public void resetPosition() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte byteAt(int position) {
            throw new IllegalArgumentException();
        }
    }
}
