package ru.yandex.webmaster3.storage.util.clickhouse2;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

/**
 * @author aherman
 */
public abstract class BAOutputStream extends OutputStream {
    public abstract void writeByte(byte b);
    public abstract void reset();
    public abstract int position();

    @Override
    public final void write(int b) {
        writeByte((byte) b);
    }

    public final void write(char b) {
        writeByte((byte) b);
    }

    public final void write(byte b) {
        writeByte(b);
    }

    public final void writeASCII(String s) {
        for (int i = 0; i < s.length(); i++) {
            write(s.charAt(i));
        }
    }

    public final void writeUtf(String s) {
        write(s.getBytes(StandardCharsets.UTF_8));
    }

    public final void write(BAInputStream is) {
        int value;
        while ((value = is.read()) != -1) {
            write(value);
        }
    }

    @Override
    public void write(byte[] b) {
        try {
            super.write(b);
        } catch (IOException e) {
            // IMPOSSIBRU
        }
    }
}
