package ru.yandex.webmaster3.storage.util.clickhouse2;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author avhaliullin
 */
public final class CHArrayType implements CHType {
    private static final Pattern NAME_PATTERN = Pattern.compile("^Array\\((.*)\\)$");

    private final CHType elementType;

    public CHArrayType(CHType elementType) {
        this.elementType = elementType;
    }

    public CHType getElementType() {
        return elementType;
    }

    @Override
    public String toString() {
        return "Array(" + elementType + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        CHArrayType that = (CHArrayType) o;

        return elementType.equals(that.elementType);

    }

    @Override
    public int hashCode() {
        return elementType.hashCode();
    }

    public static CHArrayType parseArrayType(String name) {
        Matcher m = NAME_PATTERN.matcher(name);
        if (m.find()) {
            return new CHArrayType(CHType.getType(m.group(1)));
        } else {
            return null;
        }
    }
}
