package ru.yandex.webmaster3.storage.util.clickhouse2;

/**
 * @author avhaliullin
 */
public enum CHPrimitiveType implements CHType {
    UNKNOWN,

    UInt8,
    UInt16,
    UInt32,
    UInt64,
    Int8,
    Int16,
    Int32,
    Int64,
    Float32,
    Float64,
    String,
    Date,
    DateTime,
    ;

    public static CHPrimitiveType getType(String typeName) {
        try {
            return CHPrimitiveType.valueOf(typeName);
        } catch (IllegalArgumentException e) {
            return UNKNOWN;
        }
    }
}
