package ru.yandex.webmaster3.storage.util.clickhouse2;

import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;

import java.nio.charset.Charset;
import java.util.List;

/**
 * @author tsyplyaev
 */
public class CHRowMock extends CHRow {
    private String[] fields;
    private Object[] values;

    public CHRowMock(List<String> fields, List<Object> values) {
        super(null, fields.toArray(new String[0]), null, new int[fields.size()]);
        this.values = values.toArray(new Object[0]);
    }

    public CHRowMock(String[] fields, Object[] values) {
        super(null, null, null, null);
        this.fields = fields;
        this.values = values;
    }

    @Override
    public String getString(int i) {
        return (String)values[i];
    }

    @Override
    public String getString(int i, Charset charset) {
        return (String)values[i];
    }

    @Override
    public byte[] getBytes(int i) {
        return (byte[])values[i];
    }

    @Override
    public int getInt(int i) {
        return (int)values[i];
    }

    @Override
    public int getIntUnsafe(int i) {
        return (int)values[i];
    }

    @Override
    public long getLong(int i) {
        return (long)values[i];
    }

    @Override
    public long getLongUnsafe(int i) {
        return (long)values[i];
    }

    @Override
    public float getFloat(int i) {
        return (float) values[i];
    }

    @Override
    public double getDouble(int i) {
        return (double)values[i];
    }

    @Override
    public LocalDate getLocalDate(int i) {
        return (LocalDate)values[i];
    }

    @Override
    public Instant getInstant(int i) {
        return (Instant)values[i];
    }

    @Override
    public DateTime getDateTime(int i) {
        return (DateTime)values[i];
    }

    @Override
    public List<String> getStringList(int i, Charset charset) {
        return (List<String>)values[i];
    }

    private int getColumnId(String name) {
        int i = ArrayUtils.indexOf(fields, name);
        if (i < 0 || i >= fields.length) {
            throw new IllegalArgumentException("No such column " + name + " in response");
        }

        return i;
    }
}
