package ru.yandex.webmaster3.storage.util.clickhouse2;

import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.storage.WebmasterStorageException;

/**
 * @author aherman
 */
public class ClickhouseException extends WebmasterStorageException {
    private final String query;
    private final String error;

    public ClickhouseException(String message, String query, String error) {
        super(message);
        this.query = query;
        this.error = error;
    }

    public ClickhouseException(String message, String query, String error, Throwable cause) {
        super(message, cause);
        this.query = query;
        this.error = error;
    }

    public String getQuery() {
        return query;
    }

    public String getError() {
        return error;
    }

    @Override
    protected WebmasterErrorResponse errorResponse(Class cls) {
        return new WebmasterErrorResponse.ClickhouseErrorResponse(cls, query, this);
    }
}
