package ru.yandex.webmaster3.storage.util.clickhouse2;

import java.net.URI;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

import lombok.EqualsAndHashCode;

/**
 * @author aherman
 */
public class ClickhouseHost extends ClickhouseHostLocation {
    private final URI hostURI;
    private AtomicBoolean hostIsDown = new AtomicBoolean(true);

    public ClickhouseHost(URI hostURI, String dcName, int shard) {
        super(dcName, shard);
        this.hostURI = hostURI;
    }

    public URI getHostURI() {
        return hostURI;
    }

    @Override
    public String toString() {
        return hostURI.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ClickhouseHost that = (ClickhouseHost) o;
        return Objects.equals(hostURI, that.hostURI);
    }

    public boolean isDown() {
        return hostIsDown.get();
    }

    public boolean isUp() {
        return !isDown();
    }

    void markAsDown() {
        hostIsDown.set(true);
    }

    void markAsUp() {
        hostIsDown.set(false);
    }
}
