package ru.yandex.webmaster3.storage.util.clickhouse2;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.http.HttpRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.joda.time.Duration;

import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.util.RetryUtils;
import ru.yandex.webmaster3.storage.host.CommonDataType;
import ru.yandex.webmaster3.storage.mdb.MdbClickhouseInfoService;
import ru.yandex.webmaster3.storage.mdb.model.MdbClickhouseHost;
import ru.yandex.webmaster3.storage.mdb.model.MdbClickhouseServiceType;
import ru.yandex.webmaster3.storage.settings.data.AbstractCommonDataState;

/**
 * Created by Oleg Bazdyrev on 22/09/2020.
 */
@Slf4j
public class MdbClickhouseServer extends ClickhouseServer {

    @Setter
    private MdbClickhouseInfoService mdbClickhouseInfoService;
    @Setter
    private int maxShard = 0;

    /*@Override
    protected Pair<List<ClickhouseHost>, List<ClickhouseHost>> computeClickhouseHosts() throws Exception {
        String disabledDcName = Optional.ofNullable(commonDataStateYDao.getValue(CommonDataType.DISABLED_CLICKHOUSE_DC_NAME))
                .map(AbstractCommonDataState::getValue).orElse(null);
        try {
            List<MdbClickhouseHost> mdbHosts = RetryUtils.query(RetryUtils.linearBackoff(3, Duration.standardMinutes(1L)), () ->
                    mdbClickhouseInfoService.listHosts(getClusterId()));
            List<ClickhouseHost> enabledHosts = new ArrayList<>();
            List<ClickhouseHost> disabledHosts = new ArrayList<>();
            for (MdbClickhouseHost mdbHost : mdbHosts) {
                // only Clickhouse
                if (mdbHost.getType() != MdbClickhouseServiceType.CLICKHOUSE) {
                    continue;
                }
                String dcName = mdbHost.getZoneId().toUpperCase();
                URIBuilder uriBuilder = new URIBuilder();
                uriBuilder.setScheme(WebmasterHostId.Schema.HTTPS.getSchemaName());
                uriBuilder.setHost(mdbHost.getName());
                uriBuilder.setPort(MDB_CLICKHOUSE_PORT);
                // shard
                int shard;
                if (mdbHost.getShardName().startsWith(MDB_SHARD_PREFIX)) {
                    shard = Integer.parseInt(mdbHost.getShardName().substring(MDB_SHARD_PREFIX.length())) - 1;
                } else {
                    shard = Integer.parseInt(mdbHost.getShardName()) - 1;
                }
                if (maxShard > 0 && shard >= maxShard) {
                    continue;
                }
                try {
                    ClickhouseHost chHost = new ClickhouseHost(uriBuilder.build(), dcName, shard);
                    if (dcName.equals(disabledDcName)) {
                        disabledHosts.add(chHost);
                    } else {
                        enabledHosts.add(chHost);
                    }
                } catch (Exception e) {
                    log.error("Invalid url: {}", uriBuilder.toString());
                }
            }
            return Pair.of(enabledHosts, disabledHosts);
        } catch (WebmasterException e) {
            log.error("Could not get clickhouse host list from MDB. Falling back to hardcoded list", e);
            return super.computeClickhouseHosts();
        }
    }*/

    @Override
    protected HttpClientContext createContext(HttpRequest request, ClickhouseQueryContext chContext, URI uri) {
        HttpClientContext clientContext = HttpClientContext.create();
        request.addHeader("X-ClickHouse-User", chContext.getCredentials().getUserName());
        request.addHeader("X-ClickHouse-Key", chContext.getCredentials().getPassword());
        return clientContext;
    }
}
