package ru.yandex.webmaster3.storage.util.clickhouse2;


import org.apache.commons.lang3.ArrayUtils;

/**
 * @author aherman
 */
public class SimpleByteArrayOutputStream extends BAOutputStream {
    private static final int HUGE_BUFFER_SIZE = 64 * 1024 * 1024;
    private byte[] buffer;
    private int writePosition;
    private int mark = -1;

    public SimpleByteArrayOutputStream() {
        this(128);
    }

    public SimpleByteArrayOutputStream(int capacity) {
        buffer = new byte[capacity];
    }

    public void writeByte(byte b) {
        if (writePosition == buffer.length) {
            byte[] newBuffer = new byte[getNewLength()];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        buffer[writePosition++] = b;
    }

    private int getNewLength() {
        if (buffer.length < HUGE_BUFFER_SIZE) {
            return buffer.length * 2;
        } else {
            return buffer.length + HUGE_BUFFER_SIZE;
        }
    }

    public void reset() {
        writePosition = 0;
        mark = -1;
    }

    public byte[] toByteArray() {
        if (writePosition == 0) {
            return ArrayUtils.EMPTY_BYTE_ARRAY;
        }
        int resultSize;
        if (mark < 0) {
            resultSize = writePosition;
        } else {
            resultSize = mark;
        }
        byte[] result = new byte[resultSize];
        System.arraycopy(buffer, 0, result, 0, resultSize);
        return result;
    }

    public long size() {
        return writePosition;
    }

    @Override
    public int position() {
        return writePosition;
    }

    public void mark() {
        mark = writePosition;
    }

    public void rewind() {
        if (mark < 0) {
            throw new IllegalStateException("Mark not set");
        }
        writePosition = mark;
    }

    public void commitMark() {
        mark = -1;
    }

    public BAInputStream toInputStream() {
        return new BAInputStream() {
            private int readPosition = 0;

            @Override
            public int read() {
                if (readPosition == writePosition) {
                    return -1;
                }
                return (int)buffer[readPosition++] & 0xFF;
            }

            @Override
            public void resetPosition() {
                this.readPosition = 0;
            }
        };
    }
}
