package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.List;
import java.util.function.Predicate;

/**
 * @author avhaliullin
 */
public class BoolOpCondition extends Condition {
    private final Operator operator;
    private final List<Condition> operands;

    @JsonCreator
    public BoolOpCondition(Operator operator, List<Condition> operands) {
        super(ConditionType.BOOL_OP);
        this.operator = operator;
        this.operands = operands;
    }

    public Operator getOperator() {
        return operator;
    }

    public List<Condition> getOperands() {
        return operands;
    }

    @Override
    public String toQuery() {
        switch (operator) {
            case AND:
                return "("
                        + String.join(" AND ", () -> operands.stream().map(o -> (CharSequence) o.toQuery()).iterator())
                        + ")";
            case OR:
                return "("
                        + String.join(" OR ", () -> operands.stream().map(o -> (CharSequence) o.toQuery()).iterator())
                        + ")";
            default:
                throw new RuntimeException("Unknown operator: " + operator);
        }
    }

    @Override
    public <T> Predicate<T> toPredicate(ConditionFieldExtractor<T> fieldExtractor) {
        switch (operator) {
            case AND:
                return operands.stream().map(c -> c.toPredicate(fieldExtractor)).reduce(x -> true, Predicate::and);
            case OR:
                return operands.stream().map(c -> c.toPredicate(fieldExtractor)).reduce(x -> false, Predicate::or);
        }
        throw new IllegalStateException();
    }

    public enum Operator {
        AND, OR
    }
}
