package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import ru.yandex.webmaster3.core.util.json.polymorphic.Discriminator;

/**
 * @author avhaliullin
 */
public enum ConditionType implements Discriminator<Condition> {
    CONST(ConstCondition.class),
    BOOL_OP(BoolOpCondition.class),
    NUMBER(LongCondition.class),
    FLOAT(FloatCondition.class),
    INTEGER(IntCondition.class),
    TEXT(TextCondition.class),
    TEXT_LIKE(TextLikeCondition.class),
    INT_EQUAL(IntEqualCondition.class),
    LOCAL_DATE(LocalDateCondition.class),
    INT_IN(IntInCondition.class),
    NOT(NotCondition.class),
    TEXT_MATCH_REGULAR(TextMatchRegularCondition.class),
    TEXT_POSITION(TextPositionCondition.class),
    ;

    private final Class<? extends Condition> dataClass;

    ConditionType(Class<? extends Condition> dataClass) {
        this.dataClass = dataClass;
    }

    @Override
    public Class<? extends Condition> getDataClass() {
        return dataClass;
    }
}
