package ru.yandex.webmaster3.storage.util.clickhouse2.condition;


import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.function.Predicate;

/**
 * @author avhaliullin
 */
public class ConstCondition extends Condition {
    private final boolean value;

    @JsonCreator
    public ConstCondition(boolean value) {
        super(ConditionType.CONST);
        this.value = value;
    }

    @Override
    public String toQuery() {
        return value ? "1=1" : "1=0";
    }

    @Override
    public <T> Predicate<T> toPredicate(ConditionFieldExtractor<T> fieldExtractor) {
        return value ? x -> true : x -> false;
    }

    public boolean getValue() {
        return value;
    }

    public static final ConstCondition TRUE_CONDITION = new ConstCondition(true);
    public static final ConstCondition FALSE_CONDITION = new ConstCondition(false);
}
