package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.Sets;

import java.util.Set;

/**
 * Created by ifilippov5 on 13.03.17.
 */
public class FloatCondition extends AbstractCondition<Double> {

    private static final Set<Operator> SUPPORTED_OPERATORS = Sets.newHashSet(Operator.LESS_THAN, Operator.LESS_EQUAL,
            Operator.GREATER_THAN, Operator.GREATER_EQUAL, Operator.EQUAL);

    @JsonCreator
    public FloatCondition(String fieldName, Operator operator, double value) {
        super(ConditionType.FLOAT, Double.class, fieldName, operator, value);
    }

    @Override
    protected Set<Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }
}
