package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;

/**
 * TODO может вытащить оператор в AbstractCondition?
 * Created by leonidrom on 31/03/2017.
 */
public class IntInCondition extends Condition {
    private final String fieldName;
    private final Collection<Integer> values;

    @JsonCreator
    public IntInCondition(String fieldName, Collection<Integer> values) {
        super(ConditionType.INT_IN);

        this.fieldName = fieldName;
        this.values = values;
    }

    public String getFieldName() {
        return fieldName;
    }

    public Collection<Integer> getValues() {
        return values;
    }

    @Override
    public String toQuery() {
        return fieldName + " IN (" +
                values.stream().map(Object::toString).collect(Collectors.joining(",")) +
                ')';
    }

    @Override
    public <T> Predicate<T> toPredicate(ConditionFieldExtractor<T> fieldExtractor) {
        return x -> values.contains(fieldExtractor.extract(x, fieldName, Integer.class));
    }
}
