package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.Sets;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import java.util.Set;

/**
 * @author aherman
 */
public class LocalDateCondition extends AbstractCondition<ReadablePartial> {

    private static final DateTimeFormatter CH_DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");

    private static final Set<Operator> SUPPORTED_OPERATORS = Sets.newHashSet(Operator.LESS_THAN, Operator.LESS_EQUAL,
            Operator.GREATER_THAN, Operator.GREATER_EQUAL, Operator.EQUAL);

    @JsonCreator
    public LocalDateCondition(String fieldName, Operator operator, LocalDate value) {
        super(ConditionType.LOCAL_DATE, ReadablePartial.class, fieldName, operator, value);
    }

    @Override
    protected Set<Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

    @Override
    protected String valueAsString() {
        return "'" + CH_DATE_FORMAT.print(value) + "'";
    }

}
