package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.Sets;

import java.util.Set;

/**
 * @author aherman
 */
public class LongCondition extends AbstractCondition<Long> {

    private static final Set<Operator> SUPPORTED_OPERATORS = Sets.newHashSet(Operator.LESS_THAN, Operator.LESS_EQUAL,
            Operator.GREATER_THAN, Operator.GREATER_EQUAL, Operator.EQUAL);

    @JsonCreator
    public LongCondition(String fieldName, Operator operator, long value) {
        super(ConditionType.NUMBER, Long.class, fieldName, operator, value);
    }

    @Override
    protected Set<Operator> getSupportedOperators() {
        return SUPPORTED_OPERATORS;
    }

}
