package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;

import java.util.function.Predicate;

/**
 * Created by ifilippov5 on 29.03.17.
 */
public class NotCondition extends Condition {
    private final Condition operand;

    @JsonCreator
    public NotCondition(Condition operand) {
        super(ConditionType.NOT);
        this.operand = operand;
    }

    public Condition getOperand() {
        return operand;
    }

    @Override
    public String toQuery() {
        return "NOT (" + operand.toQuery() + ")";
    }

    @Override
    public <T> Predicate<T> toPredicate(ConditionFieldExtractor<T> fieldExtractor) {
        return operand.toPredicate(fieldExtractor).negate();
    }
}
