package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import ru.yandex.webmaster3.storage.AbstractFilter;

/**
 * Не совсем ясно, зачем такие дубликаты. Похоже на AbstractFilter.Operation
 * @author aherman
 */
public enum Operator {
    LESS_THAN,
    LESS_EQUAL,
    GREATER_THAN,
    GREATER_EQUAL,

    EQUAL,

    TEXT_CONTAINS,
    TEXT_LIKE,
    TEXT_MATCH,
    ;

    public static Operator fromFilterOperation(AbstractFilter.Operation operation) {
        try {
            return Operator.valueOf(operation.toString());
        } catch (NullPointerException|IllegalArgumentException e) {
            return null;
        }
    }
}
