package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseEscapeUtils;

/**
 * @author aherman
 */
public class TextLikeCondition extends TextCondition {

    @JsonCreator
    public TextLikeCondition(String field, String text) {
        super(field, Operator.TEXT_LIKE, text);
    }

    @Override
    protected String valueAsString() {
        // уже есть экранирование в билдере
        return "'" + value + "'";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final StringBuilder sb = new StringBuilder();

        public Builder append(String s) {
            sb.append(ClickhouseEscapeUtils.trimAndEscape(s));
            return this;
        }

        public Builder appendWildcard() {
            sb.append("%");
            return this;
        }

        public TextLikeCondition build(String field) {
            return new TextLikeCondition(field, sb.toString());
        }

        @Override
        public String toString() {
            return sb.toString();
        }
    }
}
