package ru.yandex.webmaster3.storage.util.clickhouse2.condition;

import org.joda.time.DateTime;

import java.util.concurrent.TimeUnit;

/**
 * @author aherman
 */
public class TimestampCondition extends LongCondition {
    public TimestampCondition(String fieldName, Operator operator, DateTime value) {
        super(fieldName, operator, TimeUnit.MILLISECONDS.toSeconds(value.getMillis()));
    }

    public TimestampCondition(String fieldName, Operator operator, long value) {
        super(fieldName, operator, TimeUnit.MILLISECONDS.toSeconds(value));
    }
}
