package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import ru.yandex.webmaster3.storage.util.clickhouse2.query.cases.Case;

/**
 * @author tsyplyaev
 */
public class From extends GroupableLimitableOrderable {
    private final String dbTable;
    private final Statement statement;

    From(String dbTable, Statement prev) {
        super(prev);
        this.dbTable = dbTable;
        this.statement = null;
    }

    From(String db, String table, Statement prev) {
        super(prev);
        this.dbTable = db + "." + table;
        this.statement = null;
    }

    public From(Statement statement, Statement prev) {
        super(prev);
        this.statement = statement;
        this.dbTable = null;
    }

    public Where where(Case case_) {
        next = new Where(case_, this, false);
        return (Where)next;
    }

    public Where prewhere(Case case_) {
        next = new Where(case_, this, true);
        return (Where)next;
    }

    public Join join(Join.Strictness strictness, Join.Type type, Statement statement, String using, String leftAlias, String rightAlias){
        next = new Join(strictness, type, statement, using, this, leftAlias, rightAlias);
        return (Join)next;
    }

    @Override
    public String toString() {
        if (statement == null) {
            return prev.toString() + " FROM " + dbTable;
        } else {
            return prev.toString() + " FROM (" + statement.toString() + ")";
        }
    }
}
