package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import ru.yandex.webmaster3.storage.util.clickhouse2.query.cases.Case;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author tsyplyaev
 */
public class GroupBy extends GroupableLimitableOrderable {
    private final List<Object> fields;
    private boolean withTotals = false;

    GroupBy(Statement prev, Object firstField, Object... lastFields) {
        super(prev);
        fields = new ArrayList<>();
        fields.add(firstField);
        fields.addAll(Arrays.asList(lastFields));
    }

    private GroupBy(Statement prev, List<Object> fields) {
        super(prev);
        this.fields = fields;
    }

    public Having having(Case case_) {
        next = new Having(case_, this);
        return (Having)next;
    }

    @Override
    public String toString() {
        String withTotalsStr = withTotals ? " WITH TOTALS" : "";
        return prev.toString()
                + " GROUP BY "
                + fields.stream()
                .map(Object::toString)
                .collect(Collectors.joining(","))
                + withTotalsStr;
    }

    static GroupBy createWithTotals(GroupBy groupBy) {
        GroupBy newGroupBy = new GroupBy(groupBy.prev, groupBy.fields);
        newGroupBy.withTotals = true;
        return newGroupBy;
    }
}
