package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import java.util.List;

/**
 * @author tsyplyaev
 */
public class InsertInto extends Statement {
    private final String db;
    private final String table;

    InsertInto(String db, String table) {
        this.db = db;
        this.table = table;
    }

    public Values value(String field, Object value) {
        next = new Values(this);
        ((Values) next).value(field, value);
        return (Values) next;
    }

    public Fields fields(List<String> fields) {
        return fields(fields.toArray(new String[fields.size()]));
    }

    public Fields fields(String... fields) {
        next = new Fields(fields, this);
        return (Fields) next;
    }

    @Override
    public String toString() {
        return "INSERT INTO " + db + "." + table;
    }
}

