package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import ru.yandex.webmaster3.storage.util.clickhouse2.query.cases.Case;

/**
 * @author tsyplyaev
 */
public class Join extends GroupableLimitableOrderable {
    public enum Type {
        INNER,
        LEFT,
    }

    public enum Strictness {
        ANY,
        ALL,
    }

    private final Type type;
    private final Strictness strictness;
    private final Statement statement;
    private final String using;
    private final String leftAlias;
    private final String rightAlias;

    public Join(Strictness strictness, Type type, Statement statement, String using, Statement prev, String leftAlias,
                String rightAlias) {
        super(prev);
        this.type = type;
        this.strictness = strictness;
        this.statement = statement;
        this.using = using;
        this.leftAlias = leftAlias;
        this.rightAlias = rightAlias;
    }

    public Where where(Case case_) {
        next = new Where(case_, this, false);
        return (Where) next;
    }

    @Override
    public String toString() {
        String rightTable = "(" + statement + ") AS " + rightAlias;
        String leftTable = prev + " AS " + leftAlias;
        return leftTable + " " + strictness.toString() + " " + type.toString() + " JOIN " + rightTable + " USING " + using;
    }
}
