package ru.yandex.webmaster3.storage.util.clickhouse2.query;

/**
 * @author tsyplyaev
 */
public class Limit extends GroupableLimitableOrderable {
    private final int limit;
    private final Integer skip;

    Limit(int limit, Statement prev) {
        super(prev);
        this.limit = limit;
        this.skip = null;
    }

    Limit(Integer skip, int limit, Statement prev) {
        super(prev);
        this.limit = limit;
        this.skip = skip;
    }

    @Override
    public String toString() {
        if (skip == null) {
            return prev.toString() + " LIMIT " + String.valueOf(limit);
        } else {
            return prev.toString() + " LIMIT " + String.valueOf(skip) + ", " + String.valueOf(limit);
        }
    }
}
