package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Pair;

/**
 * @author tsyplyaev
 */
public class OrderBy extends GroupableLimitableOrderable {
    public enum Direction {
        ASC,
        DESC
    }

    private final List<Pair<Object, Direction>> order;

    public OrderBy(List<Pair<Object, Direction>> order, Statement prev) {
        super(prev);
        this.order = order;
    }

    @Override
    public String toString() {
        return prev
                + " ORDER BY "
                + order.stream()
                .map(p -> p.getLeft() + " " + p.getRight())
                .collect(Collectors.joining(","));
    }
}

