package ru.yandex.webmaster3.storage.util.clickhouse2.query;

/**
 * @author tsyplyaev
 */
public class Select extends GroupableLimitableOrderable {
    protected final String[] fields;

    public Select(String... fields) {
        this.fields = fields;
    }

    public From from(String dbTable) {
        next = new From(dbTable, this);
        return (From)next;
    }

    public From from(String db, String table) {
        next = new From(db, table, this);
        return (From)next;
    }

    public From from(Statement statement) {
        next = new From(statement, this);
        return (From)next;
    }

    public CountAll countAll() {
        next = new CountAll(this);
        return (CountAll)next;
    }

    @Override
    public String toString() {
        if (fields.length > 0) {
            return "SELECT " + String.join(", ", fields);
        } else {
            return "SELECT *";
        }
    }
}
