package ru.yandex.webmaster3.storage.util.clickhouse2.query;

import ru.yandex.webmaster3.storage.util.clickhouse2.query.cases.Value;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author tsyplyaev
 */
public class Values extends Statement {
    private final List<String> fields = new ArrayList<>();
    private final List<Value> values = new ArrayList<>();

    Values(Statement prev) {
        super(prev);
    }

    public Values value(String field, Object value) {
        if (value != null) {
            fields.add(field);
            values.add(new Value(value));
        }
        return this;
    }

    @Override
    public String toString() {
        return prev.toString() + "(" + String.join(", ", fields) + ") VALUES(" + join(values) + ")";
    }

    protected static final String join(List<Value> values) {
        List<String> s = values.stream().map(Object::toString).collect(Collectors.toList());
        return String.join(", ", s);
    }
}
