package ru.yandex.webmaster3.storage.util.clickhouse2.query.cases;

import java.util.Collection;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class In extends Case {
    private final String field;
    private final Collection<Value> values;

    public In(String field, Collection<?> values) {
        this.field = field;
        this.values = values.stream().map(Value::new).collect(Collectors.toList());
    }

    @Override
    public String toString() {
        return field + " IN (" + values.stream().map(Object::toString).collect(Collectors.joining(",")) + ")";
    }
}
