package ru.yandex.webmaster3.storage.util.clickhouse2.query.cases;

import java.util.List;
import java.util.stream.Collectors;

import org.apache.commons.lang3.tuple.Triple;

/**
 * @author avhaliullin
 */
public class TripleIn extends Case {
    private final String field1;
    private final String field2;
    private final String field3;
    private final List<Triple<Value, Value, Value>> values;

    public TripleIn(String field1, String field2, String field3, List<Triple<Value, Value, Value>> values) {
        this.field1 = field1;
        this.field2 = field2;
        this.field3 = field3;
        this.values = values;
    }

    @Override
    public String toString() {
        return "(" + field1 + ", " + field2  + ", " + field3 + ") IN ("
                + values
                .stream()
                .map(t -> "(" + t.getLeft().toString() + ", " + t.getMiddle().toString() + ", " + t.getRight().toString() + ")")
                .collect(Collectors.joining(","))
                + ")";
    }
}
