package ru.yandex.webmaster3.storage.util.clickhouse2.query.cases;

import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.stream.Collectors;

/**
 * @author avhaliullin
 */
public class TupleIn extends Case {
    private final String field1;
    private final String field2;
    private final List<Pair<Value, Value>> values;

    public TupleIn(String field1, String field2, List<Pair<Value, Value>> values) {
        this.field1 = field1;
        this.field2 = field2;
        this.values = values;
    }

    @Override
    public String toString() {
        return "(" + field1 + ", " + field2 + ") IN ("
                + values
                .stream()
                .map(pair -> "(" + pair.getLeft().toString() + ", " + pair.getRight().toString() + ")")
                .collect(Collectors.joining(","))
                + ")";
    }
}
