package ru.yandex.webmaster3.storage.util.clickhouse2.query.cases;

import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.LocalDate;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.storage.util.clickhouse2.AbstractClickhouseDao;
import ru.yandex.webmaster3.storage.util.clickhouse2.ClickhouseEscapeUtils;

import java.util.UUID;

/**
 * @author tsyplyaev
 */
public class Value {
    private final Object value;

    public Value(Object value) {
        this.value = value;
    }

    @Override
    public String toString() {
        if (value instanceof DateTime) {
            return "'" + AbstractClickhouseDao.toClickhouseDateTime((DateTime) value) + "'";
        } else if (value instanceof Instant) {
            return "'" + AbstractClickhouseDao.toClickhouseDateTime((Instant) value) + "'";
        } else if (value instanceof LocalDate) {
            return "'" + AbstractClickhouseDao.toClickhouseDate((LocalDate) value) + "'";
        } else if (value instanceof UUID) {
            return "'" + value.toString() + "'";
        } else if (value instanceof String) {
            return "'" + ClickhouseEscapeUtils.escapeString((String) value) + "'";
        } else if (value instanceof WebmasterHostId) {
            return "'" + ((WebmasterHostId) value).toStringId() + "'";
        } else if (value instanceof Number) {
            return value.toString();
        } else {
            return "'" + value.toString() + "'";
        }
    }
}
