package ru.yandex.webmaster3.storage.util.clickhouse2.query.types;

import ru.yandex.webmaster3.storage.util.clickhouse2.query.GroupableLimitableOrderable;
import ru.yandex.webmaster3.storage.util.clickhouse2.query.Statement;

import java.util.Collection;
import java.util.stream.Collectors;

/**
 * Выражение для поддержки clickhouse-овского limit by
 *
 * @author Oleg Bazdyrev
 */
public class LimitBy extends GroupableLimitableOrderable {

    private final int limit;
    private final Collection<String> fields;

    public LimitBy(int limit, Collection<String> fields, Statement prev) {
        super(prev);
        this.limit = limit;
        this.fields = fields;
    }

    @Override
    public String toString() {
        return prev.toString() + " LIMIT " + String.valueOf(limit) + " BY " +
                fields.stream().collect(Collectors.joining(","));
    }
}
