package ru.yandex.webmaster3.storage.util.serverresponseutil.model;

import org.joda.time.DateTime;
import ru.yandex.webmaster3.core.zora.ZoraUserAgent;
import ru.yandex.webmaster3.storage.async.model.IRequestData;

/**
 * @author: ishalaru
 * DATE: 20.05.2019
 */
public class ServerResponseUtilInputData implements IRequestData {
    private final String url;
    private final String userIp;
    private final ZoraUserAgent userAgent;
    private final DateTime ifModifiedSince;

    public ServerResponseUtilInputData(String url,
                                       String userIp,
                                       ZoraUserAgent userAgent,
                                       DateTime ifModifiedSince) {
        this.url = url;
        this.userIp = userIp;
        this.userAgent = userAgent;
        this.ifModifiedSince = ifModifiedSince;
    }


    public String getUrl() {
        return url;
    }

    public String getUserIp() {
        return userIp;
    }

    public ZoraUserAgent getUserAgent() {
        return userAgent;
    }

    public DateTime getIfModifiedSince() {
        return ifModifiedSince;
    }
}
