package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.transaction.TransactionStatus;
import ru.yandex.webmaster3.storage.WebmasterSQLException;

/**
 * @author avhaliullin
 */
public abstract class DelegatingTransactionTemplate implements TransactionTemplate {
    private final TransactionTemplate delegate;

    public DelegatingTransactionTemplate(TransactionTemplate delegate) {
        this.delegate = delegate;
    }

    @Override
    public <T> T execute(final TransactionCallback<T> transaction) throws WebmasterSQLException {
        return delegate.execute(new TransactionCallback<T>() {
            @Override
            public T doInTransaction(IWriteJdbcTemplate template, TransactionStatus transactionStatus) throws WebmasterSQLException {
                return transaction.doInTransaction(wrapTemplate(template), transactionStatus);
            }
        });
    }

    protected abstract IWriteJdbcTemplate wrapTemplate(IWriteJdbcTemplate template);
}
