package ru.yandex.webmaster3.storage.util.sql;

import ru.yandex.webmaster3.storage.WebmasterSQLException;

/**
 * @author avhaliullin
 */
public abstract class DelegatingWriteJdbcTemplate extends DelegatingReadJdbcTemplate implements IWriteJdbcTemplate {
    @Override
    protected abstract IWriteJdbcTemplate getTemplate();

    @Override
    public int update(final String sqlString, final Object... requestParams) throws WebmasterSQLException {
        return new WriteQueryProcessor<Integer>(getTemplate(), sqlString) {
            @Override
            public Integer doQuery() throws WebmasterSQLException {
                return getTemplate().update(prepareQuery(sqlString), requestParams);
            }
        }.query();
    }

    @Override
    public Number insertSingle(final String sqlString, final Object... requestParams) throws WebmasterSQLException {
        return new WriteQueryProcessor<Number>(getTemplate(), sqlString) {
            @Override
            public Number doQuery() throws WebmasterSQLException {
                return getTemplate().insertSingle(prepareQuery(sqlString), requestParams);
            }
        }.query();
    }

    protected abstract class WriteQueryProcessor<T> {
        protected final IWriteJdbcTemplate template;
        protected final String query;

        protected WriteQueryProcessor(IWriteJdbcTemplate template, String query) {
            this.template = template;
            this.query = query;
        }

        public T query() throws WebmasterSQLException {
            StartQueryInfo startInfo = new StartQueryInfo(query, true, template);
            onQueryStart(startInfo);
            long startTime = System.currentTimeMillis();
            try {
                T result = doQuery();
                beforeFinish();
                onQueryFinish(new FinishQueryInfo(startInfo, System.currentTimeMillis() - startTime, null));
                return result;
            } catch (Exception e) {
                onQueryFinish(new FinishQueryInfo(startInfo, System.currentTimeMillis() - startTime, e));
                throw e;
            }
        }

        public abstract T doQuery() throws WebmasterSQLException;
    }
}
