package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.beans.factory.annotation.Required;

/**
 * @author avhaliullin
 */
public class ForceMasterJdbcProvider implements JdbcProvider {
    private JdbcProvider jdbcProvider;

    @Override
    public String getDbIdentity() {
        return jdbcProvider.getDbIdentity();
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return jdbcProvider.getTransactionTemplate();
    }

    @Override
    public TransactionTemplate getLightTransactionTemplate() {
        return jdbcProvider.getLightTransactionTemplate();
    }

    @Override
    public IReadJdbcTemplate getReadTemplate() {
        return jdbcProvider.getWriteTemplate();
    }

    @Override
    public IWriteJdbcTemplate getWriteTemplate() {
        return jdbcProvider.getWriteTemplate();
    }

    @Required
    public void setJdbcProvider(JdbcProvider jdbcProvider) {
        this.jdbcProvider = jdbcProvider;
    }
}
