package ru.yandex.webmaster3.storage.util.sql;

import org.intellij.lang.annotations.Language;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import ru.yandex.webmaster3.storage.WebmasterSQLException;
import ru.yandex.wmtools.common.util.ParameterizedMapRowMapper;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

/**
 * @author avhaliullin
 */
public interface IReadJdbcTemplate {
    String getDbIdentity();

    int queryForInt(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    long queryForLong(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    <T> T queryForObject(@Language(value = "SQL") final String sqlString, final Class<T> aClass, final Object... requestParams) throws WebmasterSQLException;

    <T> T queryForObject(@Language(value = "SQL") final String sqlString, final RowMapper<T> rowMapper, final Object... requestParams) throws WebmasterSQLException;

    <T> List<T> query(@Language(value = "SQL") final String sqlString, final RowMapper<T> rowMapper, final Object... requestParams) throws WebmasterSQLException;

    Map<String, Object> queryForMap(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    List<Map<String, Object>> queryForList(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    Date safeQueryForTimestamp(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    Integer safeQueryForInt(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    Long safeQueryForLong(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    String safeQueryForString(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    <E> E safeQueryForObject(@Language(value = "SQL") final String sqlString, final RowMapper<E> rowMapper, final Object... requestParams) throws WebmasterSQLException;

    <K, V> NavigableMap<K, V> queryForNavigableMap(@Language(value = "SQL") final String sqlString, final ParameterizedMapRowMapper<K, V> parameterizedRowMapper, final Object... requestParams) throws WebmasterSQLException;

    void query(@Language(value = "SQL") final String sqlString, final RowCallbackHandler rch, final Object... requestParams) throws WebmasterSQLException;
//
//    /**
//     * Performs database select, for which you can specify 'limit' and 'order by', using special objects of
//     * <code>OrderByClause</code> and <code>Pager</code> type.
//     *
//     * @param countSql  Database query, returning the number of rows that will be returned during <code>selectSql</code>
//     *                  query.
//     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
//     *                  This statement must have two placeholders: '%1$s' for ORDER BY statement and '%2$s' for LIMIT
//     *                  statement, even if <code>order</code> and/or <code>pager</code> is null. If one or two of these
//     *                  objects are <code>null</code>, corresponding placeholders will be replaced by empty strings.
//     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
//     * @param order     Object, that stores information about ORDER BY statement creation.
//     * @param pager     Object, that stores information about LIMIT statement creation.
//     * @param params    Parameters of database query. Used to replace '?' marks in <code>countSql</code> and
//     *                  <code>selectSql</code>. It means, that this two strings must have the same number of '?' marks
//     *                  with equal meanings of the corresponding question marks.
//     * @return Returns list of Java objects, mapped from rows, returned by the database query
//     * <code>selectSql</code>.
//     * @throws ru.yandex.webmaster3.storage.WebmasterSqlException Thrown if something is wrong.
//     */
//    <T> List<T> select(final String countSql, final String selectSql, final ParameterizedRowMapper<T> mapper, final OrderByClause order, final Pager pager, final Object... params) throws WebmasterSqlException;
//
//    /**
//     * Performs database select, for which you can specify 'limit', using special object of <code>Pager</code> class.
//     *
//     * @param countSql  Database query, returning the number of rows that will be returned during <code>selectSql</code>
//     *                  query.
//     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
//     *                  This statement must have one placeholder: '%1$s' for LIMIT statement, even if <code>pager</code>
//     *                  is null. If so, a placeholder will be replaced by an empty string.
//     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
//     * @param pager     Object, that stores information about LIMIT statement creation.
//     * @param params    Parameters of database query. Used to replace '?' marks in <code>countSql</code> and
//     *                  <code>selectSql</code>. It means, that this two strings must have the same number of '?' marks
//     *                  with equal meanings of the corresponding question marks.
//     * @return Returns list of Java objects, mapped from rows, returned by the database query
//     * <code>selectSql</code>.
//     * @throws ru.yandex.webmaster3.storage.WebmasterSqlException Thrown if something is wrong.
//     */
//    <T> List<T> pageableSelect(final String countSql, final String selectSql, final ParameterizedRowMapper<T> mapper, final Pager pager, final Object... params) throws WebmasterSqlException;
//
//    /**
//     * Performs database select, for which you can specify 'order by', using special object of <code>OrderByClause</code> class.
//     *
//     * @param selectSql Database query, returning rows, that will be mapped into Java objects using <code>mapper</code>.
//     *                  This statement must have one placeholder: '%1$s' for ORDER BY statement, even if
//     *                  <code>order</code> is null. If so, a placeholder will be replaced by an empty string.
//     * @param mapper    Java class, that incapsulates logic of mapping database rows into Java objects.
//     * @param order     Object, that stores information about ORDER BY statement creation.
//     * @param params    Parameters of database query. Used to replace '?' marks in <code>selectSql</code>.
//     * @return Returns list of Java objects, mapped from rows, returned by the database query
//     * <code>selectSql</code>.
//     * @throws ru.yandex.webmaster3.storage.WebmasterSqlException Thrown if something is wrong.
//     */
//    <T> List<T> orderableSelect(final String selectSql, final ParameterizedRowMapper<T> mapper, final OrderByClause order, final Object... params) throws WebmasterSqlException;
}
