package ru.yandex.webmaster3.storage.util.sql;

import org.intellij.lang.annotations.Language;
import ru.yandex.webmaster3.storage.WebmasterSQLException;

/**
 * @author avhaliullin
 */
public interface IWriteJdbcTemplate extends IReadJdbcTemplate {
    int update(@Language(value = "SQL") final String sqlString, final Object... requestParams) throws WebmasterSQLException;

    /**
     * Use this method for inserting single record into table, when you need to fetch generated by MySQL key
     *
     * @param sqlString
     * @param requestParams
     * @return Number, representing generated key or null, if nothing was inserted
     * @throws ru.yandex.webmaster3.storage.WebmasterSQLException
     */
    Number insertSingle(@Language(value = "SQL") String sqlString, Object... requestParams) throws WebmasterSQLException;
}
