package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.transaction.support.TransactionTemplate;

import java.util.List;

/**
 * @author avhaliullin
 */
public class LogicalDB {
    private final String dbIdentity;
    private final TransactionTemplate transactionTemplate;
    private final IWriteJdbcTemplate mainTemplate;
    private final List<IReadJdbcTemplate> slaveTemplates;

    public LogicalDB(String dbIdentity, TransactionTemplate transactionTemplate, IWriteJdbcTemplate mainTemplate,
                     List<IReadJdbcTemplate> slaveTemplates) {
        this.dbIdentity = dbIdentity;
        this.transactionTemplate = transactionTemplate;
        this.mainTemplate = mainTemplate;
        this.slaveTemplates = slaveTemplates;
    }

    public String getDbIdentity() {
        return dbIdentity;
    }

    public TransactionTemplate getTransactionTemplate() {
        return transactionTemplate;
    }

    public IWriteJdbcTemplate getMainTemplate() {
        return mainTemplate;
    }

    public List<IReadJdbcTemplate> getSlaveTemplates() {
        return slaveTemplates;
    }
}
