package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.transaction.TransactionStatus;
import ru.yandex.webmaster3.storage.WebmasterSQLException;

/**
 * @author avhaliullin
 */
public abstract class TransactionCallbackWithoutResult implements TransactionCallback<Object> {
    protected abstract void doInTransactionWithoutResult(IWriteJdbcTemplate template, TransactionStatus transactionStatus);

    @Override
    public Object doInTransaction(IWriteJdbcTemplate template, TransactionStatus transactionStatus) throws WebmasterSQLException {
        doInTransactionWithoutResult(template, transactionStatus);
        return null;
    }
}
