package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import ru.yandex.webmaster3.storage.WebmasterSQLException;

/**
 * @author avhaliullin
 */
public class TransactionTemplateImpl implements TransactionTemplate {
    private final org.springframework.transaction.support.TransactionTemplate delegate;
    private final IWriteJdbcTemplate template;
    private final ThreadLocal<IWriteJdbcTemplate> lock;

    public TransactionTemplateImpl(org.springframework.transaction.support.TransactionTemplate delegate, IWriteJdbcTemplate template, ThreadLocal<IWriteJdbcTemplate> lock) {
        this.delegate = delegate;
        this.template = template;
        this.lock = lock;
    }

    @Override
    public <T> T execute(final TransactionCallback<T> transaction) throws WebmasterSQLException {
        boolean alreadyInTransaction = lock.get() != null;
        try {
            if (!alreadyInTransaction) {
                lock.set(template);
            }
            return delegate.execute(new org.springframework.transaction.support.TransactionCallback<T>() {
                @Override
                public T doInTransaction(TransactionStatus transactionStatus) {
                    try {
                        return transaction.doInTransaction(template, transactionStatus);
                    } catch (WebmasterSQLException e) {
                        throw new InTransactionExceptionWrap(e);
                    }
                }
            });
        } catch (TransactionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InTransactionExceptionWrap) {
                throw ((InTransactionExceptionWrap) cause).getSqlException();
            } else if (cause instanceof RuntimeException) {
                throw (RuntimeException) cause;
            } else {
                throw e;
            }
        } finally {
            if (!alreadyInTransaction) {
                lock.remove();
            }
        }
    }
}
