package ru.yandex.webmaster3.storage.util.sql;

import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementCreatorFactory;
import org.springframework.jdbc.core.SqlTypeValue;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import ru.yandex.webmaster3.storage.WebmasterSQLException;

import javax.sql.DataSource;

/**
 * @author avhaliullin
 */
public class WriteJdbcTemplate extends ReadJdbcTemplate implements IWriteJdbcTemplate {
    public WriteJdbcTemplate(DataSource dataSource, String dbIdentity) {
        super(dataSource, dbIdentity);
    }

    @Override
    public int update(final String sqlString, final Object... requestParams) throws WebmasterSQLException {
        try {
            return jdbcTemplate.update(sqlString, requestParams);
        } catch (RuntimeException e) {
            throw new WebmasterSQLException(dbIdentity, e.getMessage(), e);
        }
    }

    @Override
    public Number insertSingle(String sqlString, Object... requestParams) throws WebmasterSQLException {
        int[] paramTypes = new int[requestParams.length];
        for (int i = 0; i < requestParams.length; i++) {
            paramTypes[i] = SqlTypeValue.TYPE_UNKNOWN;
        }
        PreparedStatementCreatorFactory creatorFactory = new PreparedStatementCreatorFactory(sqlString, paramTypes);
        creatorFactory.setReturnGeneratedKeys(true);
        PreparedStatementCreator ps = creatorFactory.newPreparedStatementCreator(requestParams);
        GeneratedKeyHolder kh = new GeneratedKeyHolder();
        try {
            int updated = jdbcTemplate.update(ps, kh);
            if (updated > 0) {
                return kh.getKey();
            } else {
                return null;
            }
        } catch (RuntimeException e) {
            throw new WebmasterSQLException(dbIdentity, e.getMessage(), e);
        }
    }
}
