package ru.yandex.webmaster3.storage.util.ydb;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

import ru.yandex.webmaster3.storage.util.ydb.query.Statement;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.Select;
import ru.yandex.webmaster3.storage.util.ydb.querybuilder.typesafe.RowMapper;

/**
 * ishalaru
 * 30.11.2020
 * Интерфейс для вызова данных с YDB, в случае наличия возвращаемых данных
 **/
public interface SelectQuery {
    <T> List<T> queryForList(Statement statement, RowMapper<T> rowMapper);

    <T> List<T> queryForList(Select statement, RowMapper<T> rowMapper, Function<List<T>, Select<T>> continuationSupplier);

    <T> void streamReader(RowMapper<T> rowMapper, Consumer<T> consumer);

    <T> void streamReader(RowMapper<T> rowMapper, Consumer<T> consumer, boolean ordered);

    <T> T queryOne(Statement statement, RowMapper<T> rowMapper);
}
